/*************************************************************************
 * The contents of this file are subject to the MYRICOM MYRINET          *
 * EXPRESS (MX) NETWORKING SOFTWARE AND DOCUMENTATION LICENSE (the       *
 * "License"); User may not use this file except in compliance with the  *
 * License.  The full text of the License can found in LICENSE.TXT       *
 *                                                                       *
 * Software distributed under the License is distributed on an "AS IS"   *
 * basis, WITHOUT WARRANTY OF ANY KIND, either express or implied.  See  *
 * the License for the specific language governing rights and            *
 * limitations under the License.                                        *
 *                                                                       *
 * Copyright 2003 - 2004 by Myricom, Inc.  All rights reserved.          *
 *************************************************************************/

static const char __idstring[] = "@(#)$Id: mx_ibuffered.c,v 1.31 2006/02/15 22:16:52 loic Exp $";

#include "mx_auto_config.h"
#include "myriexpress.h"
#include "mx__lib_types.h"
#include "mx__lib.h"
#include "mx__error.h"

MX_FUNC(mx_return_t)
mx_ibuffered(mx_endpoint_t endpoint, mx_request_t *request,
	     uint32_t *result)
{
  mx_return_t ret = MX_BAD_REQUEST;
  union mx_request *r;

  MX__MUTEX_LOCK(&endpoint->lock);
  mx__luigi(endpoint);
  r = (union mx_request*)*request;
  switch(r->basic.type) {
  case MX__REQUEST_TYPE_SEND_TINY:
  case MX__REQUEST_TYPE_SEND_SMALL:
  case MX__REQUEST_TYPE_SEND_MEDIUM:
  case MX__REQUEST_TYPE_SEND_LARGE:
    if ((r->basic.state & MX__REQUEST_STATE_BUFFERED) ||
	(r->basic.state & MX__REQUEST_STATE_COMPLETED)) {
      *result = 1;
    }
    else {
      *result = 0;
    }
    ret = MX_SUCCESS;
    break;
  default:
    ret = mx__error(endpoint, "mx_ibuffered", MX_BAD_REQUEST);
    break;
  }
  MX__MUTEX_UNLOCK(&endpoint->lock);
  return ret;
}
